package Jarras;

import java.util.ArrayList;

public class ConjuntoDeJarras {
    private ArrayList<Jarra> jarras;

    public ConjuntoDeJarras() {
        this.jarras = new ArrayList<>();
    }
    
    public void agregarJarra(int capacidad) {
        jarras.add(new Jarra(capacidad));
    }

    public int cantJarras() {
        return jarras.size();
    }

    public Jarra getJarra(int indice) {
    	Jarra auxJarra;
        if (indiceValido(indice)) {
            auxJarra = jarras.get(indice);
        }else {
        	auxJarra = null;
        }
        return auxJarra;
    }

	private boolean indiceValido(int indice) {
		return (indice >= 0 && indice < jarras.size());
	}

	public void llenarJarra(int aUsar) {
		jarras.get(aUsar).llenar();
	}

	public void agregarAJarra(int cantidad, int aUsar) {
		jarras.get(aUsar).agregar(cantidad);;
	}

	public void servirDeJarra(int cantidad, int aUsar) {
		jarras.get(aUsar).servir(cantidad);;
	}

	public String obtenerEstado(int aUsar) {
		return jarras.get(aUsar).toString();
	}
	
	
}


